/***********************************************************************
	include files
***********************************************************************/
#include <Windows.h>
#include "global.hpp"
#include <winamp/gen.h>
#include <winamp/wa_ipc.h>

// ConfigDialog.cpp
extern BOOL InitializeAccountControls (HWND hWnd);
extern void fnConfig ();
// send_message.cpp
extern int send_message (char *message);



// tH[}bg瑗MbZ[W𐶐
// @see http://lab.magicvox.net/trac/public/ticket/1
// @see http://lab.magicvox.net/trac/public/ticket/3
void FormatMessage (char *message, const char *title, int bufsize) {
	char *s = g_szFormat, *d = message;
	while (0 < --bufsize && *s) {
		if (*s == '%' && *(s+1) == 's') {
			const char *t = title;
			while (0 < --bufsize && *t)
				*d++ = *t++;
			s+=2;
		}
		else
			*d++ = *s++;
	}
	*d = '\0';
}

// ꕶ̃GXP[v
// @see http://lab.magicvox.net/trac/public/ticket/2
void EscapeMessage (char *message, int bufsize) {
	char work [BUFSIZE];
	char *d = work, *s = message;
	while (*s) {
		switch (*s) {
		case '&':
			*d++ = '%'; *d++ = '2'; *d++ = '6'; *s++;
			break;
		default:
			*d++ = *s++;
		}
	}
	*d = '\0';
	lstrcpyn (message, work, bufsize);
}

// vOC{̂̃EBhD bZ[W vV[W
static WNDPROC lpWndProcOld;
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static int posted = 0;
	static int cur_pl_pos = -1;

	switch (message) {
	case WM_WA_IPC:
		switch (lParam) {
		case IPC_CB_MISC:
			switch (wParam) {
			case IPC_CB_MISC_STATUS:
			{
				int ret = (int) SendMessage (hwnd, WM_WA_IPC, 0, IPC_ISPLAYING);
				if (ret == 0)
					posted = 0; // not playing
				else {
					int pos = (int) SendMessage (hwnd, WM_WA_IPC, 0, IPC_GETLISTPOS);
					if (pos != cur_pl_pos) { // changed in playing list
						cur_pl_pos = pos;
						posted = 0;
					}
				}
			} // case
				break;
			} // switch
		} // switch
		break;

	case WM_TIMER:
		if (wParam == 64) { // ̒萔B܂39
			int ret = (int) SendMessage (hwnd, WM_WA_IPC, 0, IPC_ISPLAYING);
			if (ret == 1) { // playing
				if (lstrlen (g_szUsername) == 0 || lstrlen (g_szPassword) == 0)
					break; // AJEgݒ

				int res = (int) SendMessage (hwnd, WM_WA_IPC, 0, IPC_GETOUTPUTTIME);
				if (1000 * 60 * 3 < res && !posted) { // Đčŏ 3 
					posted = 1; // Already posted
					char *title = (char *) SendMessage (hwnd, WM_WA_IPC,
							SendMessage (hwnd, WM_WA_IPC, 0, IPC_GETLISTPOS),
							IPC_GETPLAYLISTTITLE);
					if (title && rand() <= (int) (g_nRatio / 100.0 * RAND_MAX))
					{
						char message [BUFSIZE];
						ZeroMemory (message, BUFSIZE);
						FormatMessage (message, title, BUFSIZE);
						EscapeMessage (message, BUFSIZE);
						MessageBox (hwnd, message, "DEBUG", MB_OK);/*DEBUG*/
						send_message (message);
					}
				}
			}
		}
		break;
	}      
	return CallWindowProc (lpWndProcOld, hwnd, message, wParam, lParam);
}

// WinAmp ėpvOC̃CX^X
int fnInit ();
void fnQuit ();
winampGeneralPurposePlugin g_Plugin =
{
	GPPHDR_VER,
	PLUGIN_TITLE " ver." PLUGIN_VERSION,
	fnInit,		// ֐ւ̃|C^
	fnConfig,	// ݒp֐ւ̃|C^
	fnQuit,		// n֐ւ̃|C^
};

// ֐
int fnInit ()
{
	// EBhD bZ[W vV[W㏑
	lpWndProcOld = (WNDPROC) SetWindowLong (g_Plugin.hwndParent, GWL_WNDPROC, (LONG) WndProc);

	// AJEg̓ǂݏo
	InitializeAccountControls ((HWND) NULL);

	return GEN_INIT_SUCCESS; // 
}

// n֐
void fnQuit ()
{
	// EBhD bZ[W vV[WIWiɖ߂Ă
	(WNDPROC) SetWindowLong (g_Plugin.hwndParent, GWL_WNDPROC, (LONG) lpWndProcOld);
}

// vOC̗B̃GNX|[g֐
extern "C" __declspec( dllexport ) winampGeneralPurposePlugin * winampGetGeneralPurposePlugin ()
{
	return &g_Plugin;
}