// WinMain.cpp
#include <stdio.h>
#include <conio.h>
#include <windows.h>
#include <winsock.h>
#include "../global.hpp"
#include "base64.h"
#include "utf8.h"

#pragma comment(lib, "ws2_32.lib")

#define TWITTER_API_METHOD		"POST"
#define TWITTER_API_HOSTNAME	"twitter.com"
#define TWITTER_API_ENDPOINT	"/statuses/update.xml"
#define TWITTER_API_PROTOCOL	"HTTP/1.1"

int send_message (char *message)
{
	////////////////////////////////////////
	// WSAStartup - Initialize WinSock
	BYTE bMajorVer = 1;
	BYTE bMinorVer = 0;
	WSADATA wsaData;
	if (WSAStartup (MAKEWORD (bMajorVer, bMinorVer), &wsaData))
		return (0);

	////////////////////////////////////////
	// socket - Create Socket
	SOCKET s;
	s = socket (AF_INET, SOCK_STREAM, NULL);
	if (s == INVALID_SOCKET)
		return (0);

	//
	const char *szHostname = TWITTER_API_HOSTNAME;
	struct hostent *he = gethostbyname (szHostname);
	if (!he)
		return (0);
	struct in_addr ia;
	memcpy (&ia.S_un.S_addr, he->h_addr_list[0], 4);
	char *ip4address = inet_ntoa (ia);
	if (!ip4address)
		return (0);

	// connect (port number)
	int nPort = 80;
	long ulIP = inet_addr (ip4address);
	sockaddr_in sai;
	sai.sin_family		= AF_INET;
	sai.sin_port		= htons (nPort);
	sai.sin_addr.s_addr	= ulIP;
	if (connect (s, (SOCKADDR *)&sai, sizeof (sai)) == SOCKET_ERROR)
		return (0);

	char auth[1024];
	memset (auth, 0, 1024); 
	lstrcat (auth, g_szUsername);
	lstrcat (auth, ":");
	lstrcat (auth, g_szPassword);
	base64 b64;
	const char *auth_base64 = b64.Encode (auth);

	// bZ[W UTF8 ɕϊ
	int message_size = 0;
	ConvSJistoUtf8 ((BYTE *) message, NULL, &message_size);
	BYTE *message_utf8 = new BYTE [message_size + 1];
	ConvSJistoUtf8 ((BYTE *) message, message_utf8, &message_size);
	message_utf8[message_size] = '\0';

	char msg_body[1024] = { 0 };
	lstrcat (msg_body, "status=");
	lstrcat (msg_body, (const char *) message_utf8);
	delete [] message_utf8;

	//
	char tmp[1024];
	char http_msg [1024] = { 0 };
	lstrcat (http_msg, TWITTER_API_METHOD " " TWITTER_API_ENDPOINT " " TWITTER_API_PROTOCOL "\n");
	lstrcat (http_msg, "Host: "); lstrcat (http_msg, szHostname); lstrcat (http_msg, "\n");
	lstrcat (http_msg, "Authorization: Basic "); lstrcat (http_msg, auth_base64); lstrcat (http_msg, "\n");
	itoa (lstrlen (msg_body), tmp, 10);
	lstrcat (http_msg, "Content-Length: "); lstrcat (http_msg, tmp); lstrcat (http_msg, "\n");
	lstrcat (http_msg, "\n");
	lstrcat (http_msg, msg_body);

		send (s, http_msg, lstrlen (http_msg), 0);
		// other thread
		Sleep (0);
		recv (s, http_msg, 1024, 0);

	// shutdown
	shutdown (s, 1);

	// delete cocket
	closesocket (s);

	// Finalize WinSock
	WSACleanup ();

	return (1);
}