#include <Windows.h>
#include "global.hpp"
#include <winamp/gen.h>
#include <winamp/wa_ipc.h>
#include "resource.h"

extern winampGeneralPurposePlugin g_Plugin;

static void GetIniFilePath (char *buf)
{
	GetModuleFileName (g_Plugin.hDllInstance, buf, MAX_PATH);
	lstrcat (buf, ".ini");
}

#define INI_SECTION_NAME		"Account"
#define INI_KEY_USERNAME		"Username"
#define INI_KEY_PASSWORD		"Password"
#define INI_KEY_POSTRATIO		"PostRatio"
#define INI_KEY_FORMAT			"Format"

#define INI_DEFAULT_POSTRATIO	"50"
#define INI_DEFAULT_FORMAT		"BGM: %s *Winamp*"

BOOL InitializeAccountControls (HWND hWnd)
{
	char filepath[MAX_PATH + 5];
	GetIniFilePath (filepath);

	char buf[MAX_PATH];
	// [U
	GetPrivateProfileString (INI_SECTION_NAME, INI_KEY_USERNAME, "", buf, MAX_PATH, filepath);
	lstrcpy (g_szUsername, buf);
	// pX[h
	GetPrivateProfileString (INI_SECTION_NAME, INI_KEY_PASSWORD, "", buf, MAX_PATH, filepath);
	lstrcpy (g_szPassword, buf);
	// epx
	GetPrivateProfileString (INI_SECTION_NAME, INI_KEY_POSTRATIO, INI_DEFAULT_POSTRATIO, buf, MAX_PATH, filepath);
	g_nRatio = atoi ((const char *) buf);
	// etH[}bg
	GetPrivateProfileString (INI_SECTION_NAME, INI_KEY_FORMAT, INI_DEFAULT_FORMAT, buf, MAX_PATH, filepath);
	lstrcpy (g_szFormat, buf);

	// Rg[ɐݒ
	if (hWnd) {
		SetDlgItemText (hWnd, IDC_EDIT_USERNAME, g_szUsername);
		SetDlgItemText (hWnd, IDC_EDIT_PASSWORD, g_szPassword);
		SetDlgItemInt (hWnd, IDC_POST_RATIO, g_nRatio, FALSE);
		SetDlgItemText (hWnd, IDC_EDIT_FORMAT, g_szFormat);
	}

	return TRUE;
}

static BOOL StoreAccountInformation (HWND hWnd)
{
	char filepath[MAX_PATH + 5];
	GetIniFilePath (filepath);

	char buf[MAX_PATH];
	// [U
	GetDlgItemText (hWnd, IDC_EDIT_USERNAME, buf, MAX_PATH);
	WritePrivateProfileString (INI_SECTION_NAME, INI_KEY_USERNAME, buf, filepath);
	lstrcpy (g_szUsername, buf);
	// pX[h
	GetDlgItemText (hWnd, IDC_EDIT_PASSWORD, buf, MAX_PATH);
	WritePrivateProfileString (INI_SECTION_NAME, INI_KEY_PASSWORD, buf, filepath);
	lstrcpy (g_szPassword, buf);
	// epx
	GetDlgItemText (hWnd, IDC_POST_RATIO, buf, MAX_PATH);
	WritePrivateProfileString (INI_SECTION_NAME, INI_KEY_POSTRATIO, buf, filepath);
	g_nRatio = atoi ((const char *) buf);
	// etH[}bg
	GetDlgItemText (hWnd, IDC_EDIT_FORMAT, buf, MAX_PATH);
	WritePrivateProfileString (INI_SECTION_NAME, INI_KEY_FORMAT, buf, filepath);
	lstrcpy (g_szFormat, buf);

	return TRUE;
}

// AJEg͗p_CAO{bNX̃EBhDbZ[WvV[W
INT_PTR CALLBACK DlgProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
	case WM_INITDIALOG:
		return InitializeAccountControls (hwnd);;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
			StoreAccountInformation (hwnd);
		case IDCANCEL:
			return EndDialog (hwnd, LOWORD(wParam));
		}
	}
	return FALSE;
}

// void (*g_Plugin::config)()
void fnConfig ()
{
	DialogBox (g_Plugin.hDllInstance, MAKEINTRESOURCE(IDD_ACCOUNT), g_Plugin.hwndParent, (DLGPROC) DlgProc);
}
