package MT::Plugin::CommentFileUpload;
;#	MTCommentFileUpload - RgŃt@C̃Abv[h\ɂ MovableType vOC
;#	@see http://www.magicvox.net/archive/2005/09032034.php
;#			Programmed by Piroli YUKARINOMIYA
;#			Open MagicVox - http://www.magicvox.net
use strict;
use MT::Template::Context;
use Image::Size;

;### Abvt@C̃pX ([JTCgpX)
our $szUpfilePath = '/archive/src';

;# vOCo^
if (MT->can ('add_plugin'))
{
	require MT::Plugin;
	my $plugin = MT::Plugin->new;
		$plugin->name ('MTCommentFileUpload ver 0.10 (Release 903)');
		$plugin->description ('Enable to upload the files on user comment field');
		$plugin->doc_link ('http://www.magicvox.net/archive/2005/09032034.php');
	MT->add_plugin ($plugin);
}

;# nho^
MT::Template::Context->add_container_tag (CommentFileUpload => \&MTCommentFileUpload);
MT::Template::Context->add_tag (UpfileLink => \&MTUpfileLink);
MT::Template::Context->add_tag (UpfileSize => \&MTUpfileSize);
;#MT::Template::Context->add_tag (UpfileType => \&MTUpfileType);
;#MT::Template::Context->add_tag (UpfileWidth => \&MTUpfileWidth);
;#MT::Template::Context->add_tag (UpfileHeight => \&MTUpfileHeight);



;########################################################################

;### MTCommentFileUpload
sub MTCommentFileUpload
{
	my ($ctx, $args, $cond) = @_;
	my $base = $ctx->stash ('blog')->site_path;

	;# Abvt@C
	my $me = $ctx->stash ('comment')
			or return ($ctx->_no_comment_error ('MTCommentFileUpload'));
	my $myid = int ($me->id);
	local *DH;
	if (opendir DH, $base. $szUpfilePath) {
		my @p = readdir DH;
		for my $file (@p) {
			if ($file =~ /^$myid\.[^\\\/:\.]*/) {
				$ctx->stash ('commentUpfile', $szUpfilePath. '/'. $file);

				my $builder = $ctx->stash ('builder');
				my $tokens = $ctx->stash ('tokens');
				my $out = $builder->build ($ctx, $tokens, $cond);
				return $ctx->error ($builder->errstr) unless defined $out;
				$ctx->stash ('commentUpfile', '');
				return ($out);
			}
		}
	}
	return '';
}

;### MTUpfileLink
sub MTUpfileLink
{
	my ($ctx, $args) = @_;
	return '' if (! $ctx->stash ('commentUpfile'));
    my ($site_url) = $ctx->stash('blog')->site_url =~ /(.+)\/$/;
	return ($site_url. $ctx->stash ('commentUpfile'));
}

;### MTUpfileSize
sub MTUpfileSize
{
	my ($ctx, $args) = @_;
	return '' if (! $ctx->stash ('commentUpfile'));
	return ((stat ($ctx->stash ('blog')->site_path. $ctx->stash ('commentUpfile')))[7]);
}



1;
__END__
========================================================================
2005/09/03	0.10	ŌJ
